#! /bin/bash
#
# WatchSurferService
#
# chkconfig: 2345 97 67
# description:	WatchSurferService
#
# processname: WatchSurferService
# pidfile: /var/run/WatchSurferService.pid

# Source function library.
. /etc/init.d/functions

RETVAL=0

# See how we were called.

CurDir=InstallPath
prog=$CurDir/bin/WatchSurferService

start() {
        if [ ! -f "$pidfile" ]; then
		echo -n $"Starting WatchSurferService: "
		$prog &
		sleep 2
		RETVAL=$?
		echo
		[ $RETVAL -eq 0 ]
		return $RETVAL
	else
		echo "WatchSurferService already running"
	fi
}

stop() {
	echo -n $"Stopping WatchSurferService: "
	killproc WatchSurferService
	sleep 2
	RETVAL=$?
	echo
	[ $RETVAL -eq 0 ]
	return $RETVAL
}	

restart() {
  	stop
	start
}

rhstatus() {
        status WatchSurferService
        RETVAL=$?
}       
	

case "$1" in
  start)
  	start
	;;
  stop)
  	stop
	;;
  restart)
  	restart
	;;
  status)
        rhstatus
        ;;

  *)

        echo $"Usage: $0 {start|stop|restart}"
	exit 1
esac

exit $?
